  const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_batchsummary_master_temp', {
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    Area: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    PrdType: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
      comment: "1: Tablet, 2:Capsule"
    },
    ReportType: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
      comment: "0:Standard,1:Avg"
    },
    BFGCode: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    ProductName: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL"
    },
    PVersion: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NA"
    },
    Version: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NA"
    },
    CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CubicleType: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    BatchNo: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    BatchSize: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    Side: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "NULL"
    },
    Nom: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    NMT: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Tol1NegActual:{
      type:DataTypes.STRING(50),
      allowNull:true
     },
    Tol1PosActual:{
      type:DataTypes.STRING(50),
      allowNull:true
    },
    Tol2NegActual:{
      type:DataTypes.STRING(50),
      allowNull:true
    },
    Tol2PosActual:{
      type:DataTypes.STRING(50),
      allowNull:true
    },
    Tol1Neg: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Tol1Pos: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Tol2Neg: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Tol2Pos: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    GraphOn:{
      type:DataTypes.INTEGER,
      allowNull:true
    },
    LimitOn: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: "NULL"
    },
    MinValue: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MaxValue: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    AvgValue: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Remark:{
      type:DataTypes.STRING(50),
      allowNull:true
    },
    StartDate:{
      type:DataTypes.DATEONLY,
      allowNull:true
      },
    EndDate:{
      type:DataTypes.DATEONLY,
      allowNull:true
    },
    DP: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Unit: {
      type: DataTypes.STRING(5),
      allowNull: true,
      defaultValue: "NULL"
    },
    FinalMinDT: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "00:00:00"
    },
    FinalMaxDT: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "00:00:00"
    },
    FinalAvgDT: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "00:00:00"
    },
    BatchCompleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
      comment: "0:Incomplete,1:Complete"
    },
    HMIID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    ParamName: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Stage: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    DTStdTime: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Make: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    ModelNo: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    StdLimit1: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    StdLimit2: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    StdTime: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Department: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Min_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Max_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TempRange: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    }, 
    CubicleName: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    }  
  }, {
    sequelize,
    tableName: 'tbl_batchsummary_master_temp',
    schema: 'dbo',
    timestamps: false
  });
  seq.removeAttribute('id')
  return seq
};
